package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.model.PainReading;

import java.util.ArrayList;
import java.util.List;

public class PainConverter {
	
	public static PainReadingDTO  convertPainReadingDomain( PainReading painReading ){
		PainReadingDTO dto = new PainReadingDTO();
		dto.setComments(painReading.getComments());
		dto.setPainId(painReading.getId());
		dto.setPainLevel(painReading.getPainLevel());
		dto.setReading(painReading.getReading());
		dto.setUserprofileId(painReading.getUserprofileId());
		return dto;
	}
	
	
	public static PainReading convertPainReadingDTO(PainReadingDTO painReadingDTO){
		PainReading painReading = new PainReading();
		painReading.setComments(painReadingDTO.getComments());
		painReading.setId(painReadingDTO.getPainId());
		painReading.setOplock(0);
		painReading.setPainLevel(painReadingDTO.getPainLevel());
		painReading.setReading(painReadingDTO.getReading());
		painReading.setUserprofileId(painReadingDTO.getUserprofileId());
		return painReading;
	}
	
	
	public static List<PainReadingDTO>  convertPainReadings( List<PainReading> painReadings ){
		List<PainReadingDTO> painReadingDTOS = new ArrayList<PainReadingDTO>();
		for(PainReading painreading :  painReadings){
			PainReadingDTO dto = convertPainReadingDomain(painreading);
			painReadingDTOS.add(dto);
		}
		return painReadingDTOS;
	}

}
